# Archivos de datos abiertos de Derecho al Juego Digital


Este archivo ZIP contiene archivos para estudiar e investigar sobre esta plataforma de participación.


## Núcleo

### users

* id: El identificador único de la usuaria
* name: El nombre que se muestra de la usuaria
* nickname: El nombre de usuaria de la usuaria
* about: El texto "Acerca de" incluido en el perfil de usuaria
* avatar_url: El avatar de la usuaria
* profile_url: La URL del perfil de la usuaria
* direct_messages_enabled: Si la usuaria permite mensajes directos o no
* deleted: Si la usuaria fue eliminada o no
* badge: La insignia de la usuaria
* groups: El ID y el nombre del grupo de usuarias


### user_groups

* id: El identificador único del grupo de usuarias
* name: El nombre que se muestra del grupo de usuarias
* nickname: El nombre de usuaria del grupo de usuarias
* avatar_url: El avatar del grupo de usuarias
* profile_url: La URL del perfil de la usuaria
* deleted: Si la usuaria fue eliminada o no
* badge: La insignia del grupo de usuarias
* members_count: El número de miembros que forman parte del grupo de usuarias
* members: El ID y el nombre de las usuarias que pertenecen al grupo


### metrics

* day: La fecha en la que se creó esta métrica
* metric_type: El tipo de métrica
* cumulative: El número total de métricas en este día
* quantity: El número de métricas en este día


### taxonomies

* id: El identificador único de esta taxonomía
* name: El nombre de esta taxonomía
* parent_id: Los identificadores únicos de la taxonomía "madre" (si existe)
* weight: El orden en el que se muestra esta taxonomía
* children_count: El recuento de "hijas" (sub-taxonomías) que tiene esta taxonomía
* taxonomizations_count: El recuento de los recursos (debates, proyectos, propuestas, encuentros, resultados, etc.) que utilizan esta taxonomía
* created_at: La fecha en la que se creó esta taxonomía
* updated_at: La fecha en que esta taxonomía fue actualizada por última vez
* filters_count: La cantidad de filtros que utilizan esta taxonomía
* filter_items_count: La cantidad de filtros de elementos que utilizan esta taxonomía
* part_of: Utilizado para detectar si esta taxonomía es "hija" (sub-categoría) de otra taxonomía
* is_root: Cierto ("true"): si esta taxonomía no tiene ninguna "madre" (no cuelga de otra taxonomía)



## Espacios

### participatory_processes

* id: El identificador único del proceso
* title: El título del proceso
* slug: El nombre corto del proceso (usado para fines de identificación, para la URL)
* reference: La referencia única del proceso participativo
* created_at: La fecha en la que se creó este proceso participativo
* updated_at: La fecha de la última actualización de este proceso participativo
* published_at: La fecha en la que se publicó este proceso participativo
* follows_count: El número de usuarias que siguen este proceso participativo
* hashtag: La etiqueta que utiliza el proceso en Twitter/X
* short_description: Una breve descripción del proceso
* description: Una descripción larga del proceso
* promoted: Si el proceso está destacado o no
* url: La URL del proceso participativo
* subtitle: El subtítulo del proceso
* remote_hero_image_url: La URL de la imagen principal del proceso
* announcement: La información del anuncio/aviso (llamada)
* start_date: La fecha de inicio del proceso
* end_date: La fecha de finalización del proceso
* developer_group: El grupo promotor del proceso. Quien está promoviendo el proceso.
* local_area: El área de organización del proceso. Esto es el área de organización de la que depende este proceso.
* meta_scope: Los metadatos del ámbito territorial del proceso
* participatory_scope: El ámbito territorial de la participación del proceso
* participatory_structure: La estructura participativa del proceso. Esto es como se decide en el proceso.
* target: Las destinatarias del proceso. Quien está llamado a participar en el proceso.
* area: El área a la que pertenece el proceso
* participatory_process_group: El grupo del proceso, si forma parte de alguno
* scope: El ámbito territorial del proceso
* scopes_enabled: Si el ámbito territorial está habilitado o no
* participatory_process_type: El tipo del proceso


### assemblies

* id: El identificador único del resultado
* title: El título de la asamblea
* slug: El nombre corto de la asamblea (usado para fines de identificación, para la URL)
* reference: La referencia única de la asamblea
* created_at: La fecha en la que se creó esta asamblea
* updated_at: La fecha de la última actualización de esta asamblea
* published_at: La fecha en la que se publicó esta asamblea
* follows_count: El número de usuarias que siguen esta asamblea
* hashtag: La etiqueta que utiliza la asamblea en Twitter/X
* short_description: Una breve descripción de la asamblea
* description: Una descripción larga de la asamblea
* promoted: Si la asamblea está destacada o no
* url: La URL de la asamblea
* subtitle: El subtítulo de la asamblea
* remote_hero_image_url: La URL de la imagen principal de la asamblea
* remote_banner_image_url: La URL de la imagen de la cabecera (imagen principal) de la asamblea
* announcement: La información del anuncio/aviso (llamada)
* developer_group: El grupo de promotor de la asamblea
* local_area: El área de organización de la asamblea
* meta_scope: Los metadatos del ámbito territorial de la asamblea
* participatory_scope: El ámbito territorial de la participación de la asamblea
* purpose_of_action: El propósito de la acción de la asamblea
* composition: La composición de la asamblea
* duration: La duración de la asamblea
* participatory_structure: La estructura participativa de la asamblea
* target: El objetivo de la asamblea
* decidim_scope_id: El ámbito territorial de asamblea
* area: El área a la que corresponde la asamblea
* scope: El ámbito territorial de asamblea
* scopes_enabled: Si el ámbito territorial está habilitado o no
* included_at: La fecha en que la asamblea fue incluida en la plataforma
* closing_date: La fecha de cierre de la asamblea
* created_by: Quién creó esta asamblea
* creation_date: La fecha de creación de esta asamblea
* closing_date_reason: Por qué se cerró la asamblea
* internal_organisation: La organización interna de esta asamblea
* is_transparent: Si la asamblea es transparente o no
* special_features: Qué características especiales tiene esta asamblea
* twitter_handler: Controlador de redes sociales para Twitter/X
* instagram_handler: Controlador de redes sociales para Instagram
* facebook_handler: Controlador de redes sociales para Facebook
* youtube_handler: Controlador de redes sociales para YouTube
* github_handler: Controlador de redes sociales para GitHub
* created_by_other: El área a la que corresponde la asamblea
* assembly_type: El tipo de asamblea


### conferences

* id: El identificador único de la jornada
* title: El título de la jornada
* slug: El nombre corto de la jornada (usado para fines de identificación, para la URL)
* reference: La referencia única de la jornada
* created_at: La fecha en la que se creó esta jornada
* updated_at: La fecha de la última actualización de esta jornada
* published_at: La fecha en la que se publicó esta jornada
* follows_count: El número de usuarias que siguen esta jornada
* hashtag: La etiqueta que utiliza la jornada en Twitter/X
* short_description: Una breve descripción de la jornada
* description: Una descripción larga de la jornada
* promoted: Si la jornada está destacada o no
* url: La URL de la jornada
* slogan: El lema de esta jornada
* remote_hero_image_url: La URL de la imagen principal de la jornada
* remote_banner_image_url: La URL de la imagen de la cabecera de la jornada
* location: El lugar de celebración de la jornada. Donde se llevó a cabo esta jornada.
* objectives: Los objetivos de esta jornada. Cuál fue la meta.
* start_date: La fecha en la que comenzó esta jornada.
* end_date: La fecha en la que finalizó esta jornada.
* scopes_enabled: Si el ámbito territorial está habilitado o no
* decidim_scope_id: El ámbito territorial de la jornada
* scope: El ámbito territorial de la jornada



## Componentes

### meetings

* id: El identificador único del encuentro
* author: Los datos de autoría de este encuentro
* participatory_space: A qué espacio pertenece este encuentro (proceso participativo, asamblea, etc.)
* taxonomies: Las taxonomías a las que pertenece este encuentro
* component: El componente al que pertenece este encuentro
* title: El título del encuentro
* description: La descripción del encuentro
* start_time: La fecha y hora en que se inició este encuentro
* end_time: La fecha y hora en que terminó este encuentro
* attendees: El número de personas que asistieron a este encuentro
* contributions: El número de contribuciones realizadas en este encuentro por las asistentes
* organizations: Las organizaciones que asistieron a esta reunión
* address: La dirección del encuentro en caso de que este sea presencial y tenga una ubicación física
* location: La localización del encuentro
* reference: El identificador único del recurso en esta plataforma
* attachments: El número de archivos adjuntos en este encuentro
* url: La URL del encuentro
* related_proposals: Las propuestas relacionadas con este encuentro
* related_results: Los resultados relacionados con este encuentro
* published: Cuando se publicó el encuentro
* withdrawn: Si se canceló el encuentro
* withdrawn_at: Cuando fue retirado/cancelado este encuentro
* location_hints: Detalle de ubicación dentro del lugar donde se celebró el encuentro
* created_at: La fecha en la que se creó este encuentro
* updated_at: La fecha de la última actualización del encuentro
* latitude: La latitud del lugar de encuentro
* longitude: La longitud del lugar de encuentro
* follows_count: El número de seguidoras que tiene el encuentro
* private_meeting: Si el encuentro fue privado o no
* transparent: La visibilidad del encuentro para visitantes
* registration_form_enabled: Si se habilitó, o no, un formulario de inscripción al encuentro
* comments: Los datos de los comentarios del encuentro
* online_meeting_url: La URL de la sala de videoconferencias
* closing_visible: La visibilidad de la información de cierre del encuentro
* closing_report: Acta/Informe del encuentro cerrado
* attending_organizations: Las organizaciones que asistieron a este encuentro
* registration_url: La URL para inscribirse al encuentro
* decidim_user_group_id: ID del grupo de usuarias involucrado en el encuentro
* decidim_author_type: Tipo de autoría (origen) del encuentro
* video_url: La URL del vídeo del encuentro
* audio_url: Grabación de audio del encuentro
* closed_at: La fecha en la que se cerró el encuentro
* registration_terms: Los términos y condiciones de registro al encuentro que se aceptaron antes de participar
* available_slots: El número de plazas disponibles para el encuentro
* registrations_enabled: Si se habilitó la inscripción al encuentro
* customize_registration_email: Posibilidad de introducir un correo electrónico personalizado al registrarse en el encuentro
* type_of_meeting: El tipo de reunión
* iframe_access_level: El nivel de acceso de la sala de videoconferencias del encuentro
* iframe_embed_type: El tipo de visualización de la sala de videoconferencias del encuentro
* reserved_slots: El número de plazas reservadas que tenía el encuentro
* registration_type: El tipo de inscripción al encuentro


### meeting_comments

* id: El identificador de este comentario
* created_at: La fecha en la que se creó este comentario
* body: El comentario en sí
* locale: La configuración regional (idioma) que la participante tuvo al dejar este comentario
* author: El nombre usuaria de la participante que hizo este comentario
* alignment: Si este comentario fue un favor, en contra o neutral
* depth: El lugar donde se encuentra este comentario en la terna de comentarios (si es un comentario, una respuesta a un comentario, o la respuesta de una respuesta)
* user_group: El nombre del grupo de usuarias que hizo este comentario (si lo hay)
* commentable_id: El identificador único de aquello que se podía comentar
* commentable_type: La tipología de aquello sobre lo que se realizó el comentario (si fue un resultado, una propuesta, etc.)
* root_commentable_url: La URL (dirección web) del recurso que enlaza con este comentario


### proposals

* id: El identificador único de la propuesta
* author: Los datos de autoría de esta propuesta
* taxonomies: Las taxonomías a las que pertenece esta propuesta
* participatory_space: A qué espacio pertenece este proyecto (proceso participativo, asamblea, etc.)
* component: El componente al que pertenece esta propuesta
* title: El título de la propuesta
* body: La descripción de la propuesta
* address: La dirección de la propuesta en caso de que esta tenga una ubicación física
* latitude: La latitud de la propuesta en caso de que esta tenga una ubicación física
* longitude: La longitud de la propuesta en caso de que esta tenga una ubicación física
* state: El estado de esta propuesta (por ejemplo, "Aceptado")
* state_published_at: Un sello de tiempo del momento en que se publicó la proposta
* reference: El identificador único del recurso en esta plataforma
* answer: La respuesta a la propuesta en el caso de que se haya respondido
* answered_at: La fecha en que se respondió esta propuesta
* votes: El número de apoyos que tiene esta propuesta
* endorsements: El número de adhesiones ("me gusta") que tiene esta propuesta
* comments: El número de comentarios que tiene esta propuesta
* attachments: El número de archivos adjuntos que tiene esta propuesta
* follows_count: El número de seguidoras que tiene esta propuesta
* published_at: La fecha en que se publicó esta propuesta
* url: La URL donde se puede encontrar esta propuesta
* meeting_urls: Las URL de los encuentros de los que resultó o se debatió esta propuesta
* related_proposals: Las propuestas relacionadas con esta propuesta
* is_amend: Si esta propuesta es una enmienda a otra propuesta o no
* original_proposal: La referencia de la propuesta original en el caso de que se trate de una enmienda
* withdrawn: Si esta propuesta fue retirada o no
* withdrawn_at: Cuando fue retirada esta propuesta
* created_at: La fecha en la que se creó la propuesta
* updated_at: La fecha de última actualización de la propuesta
* created_in_meeting: Si la propuesta se ha elaborado en un encuentro
* coauthorships_count: El número de coautorias que la propuesta representa
* cost: El coste total que representa la propuesta en cuestión
* cost_report: Un informe de los costes que representa la propuesta
* execution_period: El período de ejecución de la propuesta, de principio a fin


### proposal_comments

* id: El identificador de este comentario
* created_at: La fecha en la que se creó este comentario
* body: El comentario en sí
* locale: La configuración regional (idioma) que la participante tuvo al dejar este comentario
* author: El nombre usuaria de la participante que hizo este comentario
* alignment: Si este comentario fue un favor, en contra o neutral
* depth: El lugar donde se encuentra este comentario en la terna de comentarios (si es un comentario, una respuesta a un comentario, o la respuesta de una respuesta)
* user_group: El nombre del grupo de usuarias que hizo este comentario (si lo hay)
* commentable_id: El identificador único de aquello que se podía comentar
* commentable_type: La tipología de aquello sobre lo que se realizó el comentario (si fue un resultado, una propuesta, etc.)
* root_commentable_url: La URL (dirección web) del recurso que enlaza con este comentario



